extern float4x4	g_Projection :	register(c0);
extern float4	g_Dimensions :	register(c4);

extern float4	g_Colour1 :		register(c8);
extern float4	g_Colour2 :		register(c9);
extern float	g_Theta :		register(c10);
extern float2	g_PQ :			register(c11);
extern float	g_Depth :		register(c12);



struct VS_OUTPUT
{
	float4	m_Position :	POSITION;
	float4	m_Colour :		COLOR0;
	float	m_PointSize :	PSIZE;
	float2	m_TexCoord :	TEXCOORD0;
};



struct VS_INPUT
{
	float	m_Position :	TEXCOORD0;
	float	m_Speed :		TEXCOORD1;
	float	m_Colour :		TEXCOORD2;
	float	m_Size :		PSIZE;
};




/*
 * Particles vertex shader
 */
VS_OUTPUT MainVS(VS_INPUT input)
{
 	VS_OUTPUT output	=	(VS_OUTPUT) 0;

	float2	angles		=	(g_Theta * input.m_Speed + input.m_Position) * g_PQ;
	
	float2	sinAngles, cosAngles;
	sincos(angles, sinAngles, cosAngles);
	
	float	r			=	2.0f + sinAngles.y;
	float3	position	=	r * float3(cosAngles.xy, sinAngles.x);
	position.z			+=	g_Depth;

	output.m_Position	=	mul(float4(position, 1.0f), g_Projection);
	
	output.m_PointSize	=	input.m_Size * g_Dimensions.y;
	output.m_Colour		=	lerp(g_Colour1, g_Colour2, input.m_Colour);

	return output;
}